(function () {
	"use strict";

	// Wait for DOM to be ready
	if (document.readyState === "loading") {
		document.addEventListener("DOMContentLoaded", trackPageView);
	} else {
		trackPageView();
	}

	function trackPageView() {
		// Don't track if tracking data is not available
		if (typeof abcStatsTracker === "undefined") {
			return;
		}

		// Require context - no fallbacks
		if (!abcStatsTracker.context || !abcStatsTracker.context.type) {
			console.debug("ABC Stats: Missing context, skipping tracking");
			return;
		}

		// Get the relative URL including query parameters
		// This handles Plain permalinks (?p=123) and other query params
		let relativeUrl = window.location.pathname + window.location.search;

		// Convert to relative URL from site root
		const siteUrl = window.location.origin;
		if (relativeUrl.startsWith(siteUrl)) {
			relativeUrl = relativeUrl.substring(siteUrl.length);
		}

		// Ensure it starts with /
		if (!relativeUrl.startsWith("/")) {
			relativeUrl = "/" + relativeUrl;
		}

		// Prepare tracking data with required context
		const trackingData = {
			url: relativeUrl,
			title: document.title,
			context: abcStatsTracker.context,
		};

		// Send tracking request
		const headers = {
			"Content-Type": "application/json",
		};

		// Add nonce header if available (for logged-in users)
		if (abcStatsTracker.nonce) {
			headers["X-WP-Nonce"] = abcStatsTracker.nonce;
		}

		fetch(abcStatsTracker.apiUrl, {
			method: "POST",
			credentials: "same-origin",
			headers: headers,
			body: JSON.stringify(trackingData),
		}).catch(function (error) {
			// Silently handle errors - don't interrupt user experience
			console.debug("ABC Stats tracking error:", error);
		});
	}
})();
