<?php
/**
 * Plugin Name: ABC Stats
 * Plugin URI: https://abc-stats.com
 * Description: Simple view tracking without the noise. Content views only. No user tracking, no cookies, GDPR compliant.
 * Version: 0.3.1
 * Author: ABC Stats Team
 * Author URI: https://abc-stats.com
 * Text Domain: abc-stats
 * Requires at least: 6.8.2
 * Requires PHP: 8.2
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('ABC_STATS_VERSION', '0.3.1');
define('ABC_STATS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ABC_STATS_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files
require_once ABC_STATS_PLUGIN_DIR . 'includes/class-abc-stats.php';
require_once ABC_STATS_PLUGIN_DIR . 'includes/class-admin.php';
require_once ABC_STATS_PLUGIN_DIR . 'includes/class-rest-api.php';
require_once ABC_STATS_PLUGIN_DIR . 'includes/class-database.php';
require_once ABC_STATS_PLUGIN_DIR . 'includes/class-tracker.php';

// Include Plugin Update Checker
require_once ABC_STATS_PLUGIN_DIR . 'vendor/plugin-update-checker-5.6/plugin-update-checker.php';
use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

// Initialize update checker
// https://abc-stats.com/releases/abc-stats.json - If we go back to JSON info file
// https://pikon.dreamhosters.com/wp-update-server/?action=get_metadata&slug=abc-stats - test server
PucFactory::buildUpdateChecker(
	'https://abc-stats.com/updates/check/?action=get_metadata&slug=abc-stats',
    __FILE__,
    'abc-stats'
);

// Initialize the plugin
function abc_stats_init() {
    new ABC_Stats();
}
add_action('plugins_loaded', 'abc_stats_init');

// Activation hook
register_activation_hook(__FILE__, 'abc_stats_activate');
function abc_stats_activate() {
    // Create database tables
    $database = new ABC_Stats_Database();
    $database->create_tables();
    
    flush_rewrite_rules();
}

// Deactivation hook
register_deactivation_hook(__FILE__, 'abc_stats_deactivate');
function abc_stats_deactivate() {
    // Clear scheduled cleanup
    wp_clear_scheduled_hook('abc_stats_daily_cleanup');
    flush_rewrite_rules();
}
